from django.urls import path
from .views import RegisterView, LoginView, CurrentUserView, UpdateUserView, DeleteUserView, AdminDeleteUserView, FetchAllUsersView,LogoutView

urlpatterns = [
    path("register/", RegisterView.as_view(), name="register"),
    path("login/", LoginView.as_view(), name="login"),
    path("me/", CurrentUserView.as_view(), name="current_user"),
    path("update/", UpdateUserView.as_view(), name="update_user"),
    path("delete/", DeleteUserView.as_view(), name="delete_user"),
    path("admin/delete/<int:user_id>/", AdminDeleteUserView.as_view(), name="admin_delete_user"),
    path("admin/users/", FetchAllUsersView.as_view(), name="fetch_all_users"),
    path("logout/", LogoutView.as_view(), name="logout"),  # Placeholder for logout functionality
]
