from django.contrib import admin
from django.contrib.auth.admin import UserAdmin
from .models import CustomUser


class CustomUserAdmin(UserAdmin):
    model = CustomUser
    list_display = ("email", "first_name", "last_name", "phone", "is_admin", "is_customer", "is_staff", "is_active")
    list_filter = ("is_admin", "is_customer", "is_staff", "is_active")
    fieldsets = (
        (None, {"fields": ("email", "password", "first_name", "last_name", "phone", "address")}),
        ("Permissions", {"fields": ("is_admin", "is_customer", "is_staff", "is_active", "groups", "user_permissions")}),
    )
    add_fieldsets = (
        (None, {
            "classes": ("wide",),
            "fields": (
                "first_name",
                "last_name",
                "email",
                "phone",
                "address",
                "password1",
                "password2",
                "is_admin",
                "is_customer",
                "is_staff",
                "is_active",
            ),
        }),
    )
    search_fields = ("email", "first_name", "last_name", "phone")
    ordering = ("email",)


admin.site.register(CustomUser, CustomUserAdmin)
